unit FileGetAttr;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, StdCtrls, FAttrDlg;

type
  TForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    FileList: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FileListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
  FileList.Directory := DirectoryListBox1.Directory;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
  FileList.Drive := DriveComboBox1.Drive;
  FileList.Directory := DirectoryListBox1.Directory;
end;

// BeginExample: FileGetAttr
// Routine: SysUtils.FileDateToDateTime
// Routine: SysUtils.FileAge
// Routine: SysUtils.FileGetAttr
// Routine: SysUtils.FileSetAttr

// BeginCode
{
The following code reads a file's attributes into a set
variable, sets the check boxes in a file-attribute dialog
box to represent the current attributes, then executes the
dialog box. If the user changes and accepts any dialog box
settings, the code sets the file attributes to match the
changed settings.  Click on a file to launch the dialog.
}
procedure TForm1.FileListMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Attributes, NewAttributes: Word;
begin
  with FileAttrForm do
  begin
    FileDirName.Caption := FileList.Items[FileList.ItemIndex];
    { set box caption }
    FilePathName.Caption := FileList.Directory;
    { show directory name }
    ChangeDate.Caption := DateTimeToStr(FileDateToDateTime(FileAge(FileList.FileName)));
    Attributes := SysUtils.FileGetAttr(FileDirName.Caption);
    { read file attributes }
    ReadOnly.Checked := (Attributes and SysUtils.faReadOnly) = faReadOnly;
    Archive.Checked := (Attributes and faArchive) = faArchive;
    System.Checked := (Attributes and faSysFile) = faSysFile;
    Hidden.Checked := (Attributes and faHidden) = faHidden;
    if ShowModal <> id_Cancel then	{ execute dialog box }
    begin
      NewAttributes := Attributes;
      { start with original attributes }
      if ReadOnly.Checked then
        NewAttributes := NewAttributes or SysUtils.faReadOnly
      else
        NewAttributes := NewAttributes and not SysUtils.faReadOnly;
      if Archive.Checked then
        NewAttributes := NewAttributes or faArchive
      else
        NewAttributes := NewAttributes and not faArchive;
      if System.Checked then
        NewAttributes := NewAttributes or faSysFile
      else
        NewAttributes := NewAttributes and not faSysFile;
      if Hidden.Checked then 
        NewAttributes := NewAttributes or faHidden
      else
        NewAttributes := NewAttributes and not faHidden;
      if NewAttributes <> Attributes then { if anything changed... }
        FileSetAttr(FileDirName.Caption, NewAttributes);
         { ...write the new values }
    end;
  end;
end;
// EndCode
// EndExample: FileGetAttr
end.
