{
FileDateToDateTime, FileAge, FileGetAttr, FileSetAttr example
The following code reads a file's attributes into a set variable, sets the check boxes in a file-attribute dialog box to represent the current attributes, then executes the dialog box. If the user changes and accepts any dialog box settings, the code sets the file attributes to match the changed settings:
} 
procedure TFMForm.Properties1Click(Sender: TObject);
var
  Attributes, NewAttributes: Word;
begin
  with FileAttrForm do
  begin
    FileDirName.Caption := FileList.Items[FileList.ItemIndex];
    { set box caption }
    PathName.Caption := FileList.Directory;
    { show directory name }
    ChangeDate.Caption := 
      DateTimeToStr(FileDateToDateTime(FileAge(FileList.FileName)));
    Attributes := FileGetAttr(FileDirName.Caption);
    { read file attributes }
    ReadOnly.Checked := (Attributes and SysUtils.faReadOnly) = faReadOnly;
    Archive.Checked := (Attributes and faArchive) = faArchive;
    System.Checked := (Attributes and faSysFile) = faSysFile;
    Hidden.Checked := (Attributes and faHidden) = faHidden;
    if ShowModal <> id_Cancel then	{ execute dialog box }
    begin
      NewAttributes := Attributes;
      { start with original attributes }
      if ReadOnly.Checked then
        NewAttributes := NewAttributes or SysUtils.faReadOnly
      else 
        NewAttributes := NewAttributes and not SysUtils.faReadOnly;
      if Archive.Checked then
        NewAttributes := NewAttributes or faArchive
      else 
        NewAttributes := NewAttributes and not faArchive;
      if System.Checked then 
        NewAttributes := NewAttributes or faSysFile
      else 
        NewAttributes := NewAttributes and not faSysFile;
      if Hidden.Checked then 
        NewAttributes := NewAttributes or faHidden
      else 
        NewAttributes := NewAttributes and not faHidden;
      if NewAttributes <> Attributes then { if anything changed... }
        FileSetAttr(FileDirName.Caption, NewAttributes);
         { ...write the new values }
    end;
  end;
end; 
