unit FileListBoxIndexOf;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    Label1: TLabel;
    procedure DirectoryListBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FileListBoxIndexOf
// Event: FileCtrl.TDirectoryListBox.OnChange
// Method: Classes.TStrings.IndexOf
// Class: FileCtrl.TDirectoryListBox
// Class: FileCtrl.TFileListBox

// BeginCode
{
This example uses a file list box, a directory list box, and
a label on a form. When the user uses the directory list box
to change directories, a message appears and the color of
the form changes if the file AUTOEXEC.BAT is in the new
directory. The code is written in the OnChange event of the
directory list box:
}
procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
  if FileListBox1.Items.IndexOf('AUTOEXEC.BAT') > -1 then
  begin
    Color := clYellow;
    Label1.Caption := 'You are in the root directory!';
  end
  else
  begin
    Color := clBtnFace;
    Label1.Caption := '';
  end;
end;
// EndCode
// EndExample: FileListBoxIndexOf
end.
