unit FileSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FileSearch
// Routine: SysUtils.FileSearch
// Routine: Dialogs.ShowMessage

// BeginCode
{
The following example uses an edit control and a button on a
form. When the button is clicked, the current directory is
searched for the filename specified in the edit control. A
message box indicates whether the file is found.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  FileToFind: string;
begin
  FileToFind := SysUtils.FileSearch(Edit1.Text, GetCurrentDir);
  if FileToFind = '' then
    ShowMessage('Couldn''t find ' + Edit1.Text + '.')
  else
    ShowMessage('Found ' + FileToFind + '.');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Label2.Caption := GetCurrentDir;
end;
// EndCode
// EndExample: FileSearch
end.
