unit FileToGrid;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    StringGrid1: TStringGrid;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    SaveDialog1: TSaveDialog;
    Button5: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FileToGrid
// Routine: SysUtils.FileExists
// Routine: SysUtils.FileOpen
// Routine: SysUtils.FileSeek
// Routine: SysUtils.FileRead
// Routine: SysUtils.FileWrite
// Routine: SysUtils.FileClose

// BeginCode
{
The following example uses a button, a string grid, and an
Open dialog box on a form. When the button is clicked, the
user is prompted for a filename. When the user clicks OK,
the specified file is opened, read into a buffer, and closed.
Then the buffer is displayed in two columns of the string
grid. The first column contains the character values in the
buffer. The second column contains the numeric values of the
characters in the buffer.
}
// Read File to Grid
procedure TForm1.Button1Click(Sender: TObject);
var
  iFileHandle: Integer;
  iFileLength: Integer;
  iBytesRead: Integer;
  Buffer: PAnsiChar;
  X, Y, I: Integer;
  StringLen, colcnt, rowcnt: Integer;
  cellString: String;
begin
  if OpenDialog1.Execute then
  begin
    try
      iFileHandle := SysUtils.FileOpen(OpenDialog1.FileName, fmOpenRead);
      iFileLength := SysUtils.FileSeek(iFileHandle,0,2);
      FileSeek(iFileHandle,0,0);
//      Buffer := PChar(System.AllocMem(iFileLength + 1));
//      iBytesRead := SysUtils.FileRead(iFileHandle, Buffer^, iFileLength);
//      FileClose(iFileHandle);
//      iFileHandle := SysUtils.FileOpen(OpenDialog1.FileName, fmOpenRead);
//      iFileLength := SysUtils.FileSeek(iFileHandle,0,2);
//      FileSeek(iFileHandle,0,0);
      colcnt := StringGrid1.ColCount;
      iBytesRead := SysUtils.FileRead(
        iFileHandle,
        colcnt,
        4);  // 4 because it's an integer
      rowcnt := StringGrid1.RowCount;
      iBytesRead := SysUtils.FileRead(
        iFileHandle,
        rowcnt,
        4);  // 4 because it's an integer
    for X := 0 to StringGrid1.ColCount - 1 do
    begin
      for Y := 0 to StringGrid1.RowCount - 1 do
      begin
        try
          iBytesRead := SysUtils.FileRead(iFileHandle, StringLen, 4);  // 4 because it's an integer
          Buffer := System.AllocMem(StringLen + 1);
//          GetMem(Buffer, StringLen); { allocate the buffer }
          iBytesRead := SysUtils.FileRead(iFileHandle, Buffer^, StringLen);
//          for I := 1 to StringLen do
//            cellString[I] := Buffer[I - 1];
          StringGrid1.Cells[X,Y] := AnsiString(Buffer);
        finally
          FreeMem(Buffer);
        end;
      end;
    end;
    finally
      FileClose(iFileHandle);
    end;
  end;
end;

// Write Grid into File
procedure TForm1.Button2Click(Sender: TObject);
var
  BackupName: string;
  FileHandle: Integer;
  StringLen: Integer;
  X, Y, I: Integer;
  colCountLength, rowCountLength: Integer;
  Buffer: PAnsiChar;
  cellString: AnsiString;
begin
  if SaveDialog1.Execute then
  begin
    if FileExists(SaveDialog1.FileName) then
    begin
      BackupName := SysUtils.ExtractFileName(SaveDialog1.FileName);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(SaveDialog1.FileName, BackupName) then
        raise Exception.Create('Unable to create backup file.');
    end;
    FileHandle := FileCreate(SaveDialog1.FileName);
    { Write out the number of rows and columns in the grid. }
    colCountLength := SizeOf(StringGrid1.ColCount);
    FileWrite(FileHandle, 
      PAnsiChar(StringGrid1.ColCount), colCountLength);
    rowCountLength := SizeOf(StringGrid1.RowCount);
    FileWrite(FileHandle,
      PAnsiChar(StringGrid1.RowCount), rowCountLength);
    for X := 0 to StringGrid1.ColCount - 1 do
    begin
      for Y := 0 to StringGrid1.RowCount - 1 do
      begin
        try
          { Write out the length of each string, followed by the string itself. }
          StringLen := Length(StringGrid1.Cells[X,Y]);
          FileWrite(FileHandle, PChar(StringLen), SizeOf(StringLen));
          GetMem(Buffer, StringLen); { allocate the buffer }
          cellString := StringGrid1.Cells[X,Y];
          for I := 1 to StringLen do
             Buffer[I - 1] := cellString[I];
          FileWrite(FileHandle, Buffer^, StringLen);
        finally
          FreeMem(Buffer, StringLen);
        end;
      end;
    end;
    FileClose(FileHandle);
  end;
end;
// EndCode
// EndExample: FileToGrid

// Clear Grid
procedure TForm1.Button3Click(Sender: TObject);
var   X, Y, I: Integer;
begin
    for X := 0 to StringGrid1.ColCount - 1 do
    begin
      for Y := 0 to StringGrid1.RowCount - 1 do
      begin
        StringGrid1.Cells[X,Y] := '';
      end;
    end;
end;

// Fill Grid
procedure TForm1.Button4Click(Sender: TObject);
begin
  with StringGrid1 do
  begin
    Cells[1,0] := 'Column 1';
    Cells[2,0] := 'Column 2';
    Cells[3,0] := 'Column 3';
    Cells[4,0] := 'Column 4';
    Cells[0,1] := 'Row 1';
    Cells[1,1] := 'Object';
    Cells[2,1] := 'Pascal';
    Cells[3,1] := 'is';
    Cells[4,1] := 'excellent';
    Cells[0,2] := 'Row 2';
    Cells[1,2] := 'Delphi';
    Cells[2,2] := 'is';
    Cells[4,2] := 'RAD';
  end;
end;

var currCellCol, currCellRow: Integer;

// Alter Cell
procedure TForm1.Button5Click(Sender: TObject);
begin
  StringGrid1.Cells[currCellCol,currCellRow] := Edit1.Text;
end;

procedure TForm1.StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  StringGrid1.MouseToCell(X, Y, &currCellCol, &currCellRow);
end;

end.
