unit FilterIndex;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FilterIndex
// Property: Dialogs.TOpenDialog.FilterIndex
// Property: Dialogs.TOpenDialog.Files
// Property: Classes.TStrings.Strings
// Method: Classes.TStrings.Append

// BeginCode
{
This example uses an Open dialog box, a memo, and a button
on a form. When the user clicks the button, the Open dialog
box appears. When the user selects files in the dialog box
and chooses the OK button, the first line from each of the
files is added to the memo. Choose multiple files using the
CNTL key or the SHIFT key.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  I: integer;
  F: TextFile;
  FirstLine: string;
begin
  OpenDialog1.Options := [ofAllowMultiSelect, ofFileMustExist];
  OpenDialog1.Filter := 'Text files (*.txt)|*.txt|All files (*.*)|*.*';
  OpenDialog1.FilterIndex := 2; { start the dialog showing all files } 
  if OpenDialog1.Execute then
    with OpenDialog1.Files do
      for I := 0 to Count - 1 do
      begin
        AssignFile(F, Strings[I]);  { next file in Files property }
        Reset(F);
        Readln(F, FirstLine);  { Read the first line out of the file }
        Memo1.Lines.Append(FirstLine);  { Add the line to the memo }
        CloseFile(F);
      end;
end;
// EndCode
// EndExample: FilterIndex
end.
