{
FilterIndex, Files, Strings, Append example
This example uses an Open dialog box, a memo, and a button on a form. When the user clicks the button, the Open dialog box appears. When the user selects files in the dialog box and chooses the OK button, the first line from each of the files is added to the memo.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  I: integer;
  F: TextFile;
  FirstLine: string;
begin
  OpenDialog1.Options := [ofAllowMultiSelect, ofFileMustExist];
  OpenDialog1.Filter := 'Text files (*.txt)|*.txt|All files (*.*)|*.*';
  OpenDialog1.FilterIndex := 2; { start the dialog showing all files } 
  if OpenDialog1.Execute then
    with OpenDialog1.Files do
      for I := 0 to Count - 1 do
      begin
        AssignFile(F, Strings[I]);  { next file in Files property }
        Reset(F);
        Readln(F, FirstLine);  { Read the first line out of the file }
        Memo1.Lines.Append(FirstLine);  { Add the line to the memo }
        CloseFile(F);
      end;
end; 
