unit FindComponent;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FindComponent
// Method: Classes.TComponent.FindComponent

// BeginCode
{
The following example creates 20 edit boxes, using
FindComponent with the edit box name to access each newly
created edit box.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  i: Integer;
const
  NamePrefix = 'MyEdit';
begin
  for i := 1 to 20 do begin
    TEdit.Create(Self).Name := NamePrefix + IntToStr(i);
    with TEdit(FindComponent(NamePrefix + IntToStr(i))) do
    begin
      Left := 10;
      Top := i * 20;
      Parent := self;
    end;
  end;
end; 
// EndCode
// EndExample: FindComponent
end.
