unit FindField;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DS2DataChange(Sender: TObject; Field: TField);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Customers: TTable;
implementation

{$R *.dfm}

// BeginExample: FindField
// Method: DB.TDataSet.FindField
// Method: DB.TField.AsString
// Event: DB.TDataSource.OnDataChange

// BeginCode
{
This example uses a button to copy the value of a field in
the previous record into the corresponding field in the
current record.  The field to copy is specified by using
FindField and the name of the field.
}
procedure TForm1.Button1Click(Sender: TObject);
var
   SavePlace: TBookmark;
   PrevValue: Variant;
begin
  Close;
   with Customers do
   begin
    { get a bookmark so that we can return to the same record }
    SavePlace := GetBookmark;
    try
      { move to prior record}
      FindPrior; 
      { get the value }
      { This is the safe way to get 'CustNo' field }
      PrevValue := FindField('Field2').Value;
      { This is *not* the safe way to change 'CustNo' field }
//    PrevValue := Fields[1].Value;
      { Move back to the bookmark
      this may not be the next record anymore
      if something else is changing the dataset asynchronously }
      GotoBookmark(SavePlace);
      { Set the value }
      Edit;
      { This is the safe way to change 'CustNo' field }
      FindField('Field2').AsString := PrevValue;
      { This is *not* the safe way to change 'CustNo' field }
//      Fields[1].AsString := PrevValue;
      { Free the bookmark }
    finally
      FreeBookmark(SavePlace);
    end;
  end;
end;

{
To ensure that the button is disabled when there is no
previous record, the OnDataChange event of the DataSource
detects when the user moves to the beginning of file (BOF
property becomes true), and disables the button.  Detection
occurs on scrolling and editing, not selection with the mouse.
}
procedure TForm1.DS2DataChange(Sender: TObject; Field: TField);
begin
  if Customers.Bof then
    Button1.Enabled := False
  else
    Button1.Enabled := True;
end;
// EndCode
// EndExample: FindField

procedure TForm1.Button2Click(Sender: TObject);
begin
  Customers.Close;
  Customers.DeleteTable;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
//    TableName := 'Flights';
//    This path depends on the Demos directory of your RAD Studio installation.
//    DatabaseName :=
//      'c:\Documents and Settings\All Users\Documents\RAD Studio\6.0\Demos\IntraWeb\Win32\FlightInformation\Data';
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    ReadOnly:= False;

//    Overwrite any existing table
    if Customers.Exists then
    begin
        Customers.Close;
        Customers.DeleteTable;
    end;
    begin
//      The Table component must not be active
//      First, describe the type of table and give
//      it a name
//      Next, describe the fields in the table
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
//      Next, describe any indexes
      with IndexDefs do
      begin
        Clear;
//        The 1st index has no name because it is
//        a Paradox primary key
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
//      Call the CreateTable method to create the table
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 20 do
        Customers.AppendRecord([i*111, i*222]);
    end;

  end;
  DS2.DataSet:= Customers;
  DBGrid2.DataSource.DataSet:= Customers;
  Customers.Active:= True;
  DS2.OnDataChange:= DS2DataChange;
end;
end.
