unit FindFirst;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    StringGrid1: TStringGrid;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FindFirst
// Routine: SysUtils.FindFirst
// Routine: SysUtils.FindNext
// Routine: SysUtils.FindClose
// Type: SysUtils.TSearchRec

// BeginCode
{
The following example uses an edit control, a button, a
string grid, and seven check boxes. The check boxes
correspond to the seven possible file attributes. When the
button is clicked, the path specified in the edit control is
searched for files matching the checked file attributes. The
names and sizes of the matching files are inserted into the
string grid.  The Path constant parameter is the directory
and file name mask, including wildcard characters. For
example, '.\test\*.*' specifies all files in the current
directory. Click at least one box before clicking the button.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  sr: TSearchRec;
  FileAttrs: Integer;
begin
  StringGrid1.RowCount := 1;
  if CheckBox1.Checked then
    FileAttrs := faReadOnly
  else
    FileAttrs := 0;
  if CheckBox2.Checked then
    FileAttrs := FileAttrs + faHidden;
  if CheckBox3.Checked then
    FileAttrs := FileAttrs + faSysFile;
  if CheckBox4.Checked then
    FileAttrs := FileAttrs + faVolumeID;
  if CheckBox5.Checked then
    FileAttrs := FileAttrs + faDirectory;
  if CheckBox6.Checked then
    FileAttrs := FileAttrs + faArchive;
  if CheckBox7.Checked then
    FileAttrs := FileAttrs + faAnyFile;
  with StringGrid1 do
  begin
    RowCount := 0;
    if SysUtils.FindFirst(Edit1.Text, FileAttrs, sr) = 0 then
    begin
      repeat
        if (sr.Attr and FileAttrs) = sr.Attr then
        begin
        RowCount := RowCount + 1;
        Cells[1,RowCount-1] := sr.Name;
        Cells[2,RowCount-1] := IntToStr(sr.Size);
        end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
  end;
end;
// EndCode
// EndExample: FindFirst
end.
