unit FindText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    RichEdit1: TRichEdit;
    FindDialog1: TFindDialog;
    procedure Button1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FindText
// Property: Dialogs.TFindDialog.Position
// Method: Dialogs.TFindDialog.Execute
// Method: ComCtrls.TCustomRichEdit.FindText
// Property: Dialogs.TFindDialog.FindText
// Event: Dialogs.TFindDialog.OnFind
// Property: StdCtrls.TCustomEdit.SelStart
// Property: StdCtrls.TCustomEdit.SelLength
// Property: Dialogs.TFindDialog.Options
// Class: ComCtrls.TSearchTypes
// Routine: SysUtils.Beep
// Type: Dialogs.TFindOptions

// BeginCode
{
This example requires a TRichEdit, a TButton, and a 
TFindDialog.  Clicking the button click will display a Find 
Dialog to the right of the edit control.  Filling in the 
"Find what" text and pressing the Find Next button will 
select the first matching string in the Rich Edit control 
that follows the previous selection.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  FindDialog1.Position := 
    Point(RichEdit1.Left + RichEdit1.Width, RichEdit1.Top);
  FindDialog1.Execute;
end;

procedure TForm1.FindDialog1Find(Sender: TObject);
var
  FoundAt: LongInt;
  StartPos, ToEnd: Integer;
  mySearchTypes : TSearchTypes;
  myFindOptions : TFindOptions;
begin
  mySearchTypes := [];
  with RichEdit1 do
  begin
    if frMatchCase in FindDialog1.Options then
       mySearchTypes := mySearchTypes + [stMatchCase];
    if frWholeWord in FindDialog1.Options then
       mySearchTypes := mySearchTypes + [stWholeWord];
    { begin the search after the current selection if there is one }
    { otherwise, begin at the start of the text }
    if SelLength <> 0 then
      StartPos := SelStart + SelLength
    else
      StartPos := 0;
    { ToEnd is the length from StartPos to the end of the 
      text in the rich edit control }
    ToEnd := Length(Text) - StartPos;
    FoundAt := 
      FindText(FindDialog1.FindText, StartPos, ToEnd, mySearchTypes);
    if FoundAt <> -1 then
    begin
      SetFocus;
      SelStart := FoundAt;
      SelLength := Length(FindDialog1.FindText);
    end
    else Beep;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
const Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := False;
  RichEdit1.Lines.LoadFromFile(Path);
  RichEdit1.ScrollBars := ssVertical;
end;
// EndCode
// EndExample: FindText
end.
