unit FloodFill;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FloodFill
// Method: Graphics.TCanvas.FloodFill

// BeginCode
{
The following code floodfills from the center point of 
Form1's client area until the color black is encountered:
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  Canvas.Brush.Color := clBlue;
  Canvas.Brush.Style := bsDiagCross;
  Canvas.FloodFill(
    ClientWidth div 2, ClientHeight div 2, clBlack, fsBorder);
end;

procedure TForm1.Button2Click(Sender: TObject);
var ewidth, eheight: integer;
begin
  ewidth := 400;
  eheight := 200;
  Canvas.Brush.Color := clRed;
  Canvas.Pen.Color := clBlack;
  Canvas.Ellipse(
    (ClientWidth - ewidth) div 2, 
    (ClientHeight - eheight) div 2, 
    ewidth, eheight);
end;
// EndCode
// EndExample: FloodFill
end.
