unit FormCount;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Item11: TMenuItem;
    Item21: TMenuItem;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FormCount
// Property: Menus.TMenu.Items
// Property: Forms.TScreen.FormCount
// Property: Forms.TScreen.Forms
// Method: Menus.TMenuItem.Add
// Method: Menus.TMenuItem.Create
// Property: Menus.TMenuItem.Caption

// BeginCode
{
This example assumes that the main form of the application
has a main menu with a menu item. The following code adds a
separator, and the name of all forms to the menu. Do not
access FormCount in the mainform's FormCreate.  The other
forms do not exist yet!
}
procedure TForm1.Button1Click(Sender: TObject);
var
  NewItem: TMenuItem;
  I : integer;
begin
  { first create the separator }
  NewItem := TMenuItem.Create(MainMenu1.Items[1]);
  NewItem.Name:= 'Separator';
  NewItem.Caption := '-';
  { add the new item to the Windows menu }
  MainMenu1.Items[1].Add(NewItem);
  { now create and add a menu item for each form }
  for  I := 0 to Screen.FormCount-1 do
  begin
    NewItem := TMenuItem.Create(MainMenu1.Items[1]);
    NewItem.Caption := Screen.Forms[I].Name + 'Item';
    NewItem.Name := Screen.Forms[I].Name;
    MainMenu1.Items[1].Add(NewItem);
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  I : Integer;
begin
  // Count down, not up!
  for  I := MainMenu1.Items[1].Count - 1 downto 0 do
  begin
    MainMenu1.Items[1].Items[I].Free;
  end;
end;
// EndCode
// EndExample: FormCount
end.
