unit FormatCount;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Button2: TButton;
    Image1: TImage;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FormatCount
// Property: Clipbrd.TClipboard.FormatCount
// Property: Clipbrd.TClipboard.Formats

// BeginCode
{
The following code adds each format on the Clipboard to
ListBox1 when Button1 is clicked.  Something must be on
the Clipboard for Formats to work.  Load the Clipboard
by doing a Paste in another window.

Note: You will need to add Clipbrd to the uses clause (Delphi)
or include <Clipbrd.hpp> (C++).
}

uses clipbrd;

procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to Clipboard.FormatCount - 1 do
    ListBox1.Items.Add(IntToStr(Clipboard.Formats[I]));
end;
// EndCode
// EndExample: FormatCount

procedure TForm1.Button2Click(Sender: TObject);
var
  MyFormat : Word;
  Bitmap : TBitMap;
  AData : THandle;
  APalette : HPALETTE;
begin
  Bitmap := TBitmap.Create;
  try
    Bitmap.LoadFromFile('c:\Program Files\Common Files\CodeGear Shared\Images\Splash\256color\factory.bmp');
    Bitmap.SaveToClipBoardFormat(
      MyFormat,
      AData,
      APalette);
    ClipBoard.SetAsHandle(MyFormat,AData);
  finally
    Bitmap.Free;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Bitmap : TBitmap;
begin
 Bitmap := TBitMap.Create;
 try
   Image1.Picture.RegisterClipboardFormat(cf_BitMap,TIcon);
   Bitmap.LoadFromClipBoardFormat(
     cf_BitMap,ClipBoard.GetAsHandle(cf_Bitmap),0);
   Image1.Canvas.Draw(0,0,Bitmap);
 finally
   Bitmap.free;
   Clipboard.Clear;
 end;
end;

end.
