unit FormatFloat;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FormatFloat
// Routine: SysUtils.FormatFloat
// Routine: SysUtils.StrToFloat

// BeginCode
{
The following example uses two buttons, a string grid, and
text edit on a form. When the conversion button is clicked,
the values across the top of the string grid are converted
using the formats along the left side.  Select a cell and
use the Alter Cell button and text edit to change the
values converted and the conversion formats.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  X, Y, I: Integer;
begin
  for X := 1 to StringGrid1.ColCount - 1 do
  begin
    for Y := 0 to StringGrid1.RowCount - 1 do
    begin
      StringGrid1.Cells[X,Y] := SysUtils.FormatFloat(
        StringGrid1.Cells[0,Y], StrToFloat(StringGrid1.Cells[X,0]));
    end;
  end;

end;

var currCellCol, currCellRow: Integer;

// Alter Cell
procedure TForm1.Button2Click(Sender: TObject);
begin
  StringGrid1.Cells[currCellCol,currCellRow] := Edit1.Text;
end;

procedure TForm1.StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  StringGrid1.MouseToCell(X, Y, &currCellCol, &currCellRow);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  StringGrid1.Cells[1,0] := '1234';
  StringGrid1.Cells[2,0] := '-1234';
  StringGrid1.Cells[3,0] := '0.5';
  StringGrid1.Cells[4,0] := '0';
  StringGrid1.Cells[0,1] := '';
  StringGrid1.Cells[0,2] := '0';
  StringGrid1.Cells[0,3] := '0.00';
  StringGrid1.Cells[0,4] := '#.##';
  StringGrid1.Cells[0,5] := '#,##0.00';
  StringGrid1.Cells[0,6] := '#,##0.00;(#,##0.00)';
  StringGrid1.Cells[0,7] := '#,##0.00;;Zero';
  StringGrid1.Cells[0,8] := '0.000E+00';
  StringGrid1.Cells[0,9] := '#.###E-0';
end;
// EndCode
// EndExample: FormatFloat
end.
