unit Generics;

interface

// BeginExample: GenericsTList
// Class: Generics.Collections.TCollectionNotification

// BeginCode
{
This example requires a button and two TListboxes on a form.
The Generics.Collections objects are created dynamically.
Notice that you can call the TList Soft method with the
TComparer as a parameter, or create the TList with the
TComparer and just call Sort.  Also, do not free reverseComp
after associating it with sortlist.
}
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Defaults,
  Generics.Collections;   // must appear after Classes to use the correct TCollectionNotification

type
  TForm2 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ListBox3: TListBox;
    ListBox4: TListBox;
    Label4: TLabel;
    ListBox5: TListBox;
    Label5: TLabel;
    ListBox6: TListBox;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Dictionary: TDictionary<Integer, Integer>;
    procedure OnDictAdd(
      Sender: TObject; const Item: Integer; Action: TCollectionNotification);
  end;
  TReverseIntComparer = class(TComparer<Integer>)
    function Compare(const Left, Right: Integer): Integer; override;
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}
{$APPTYPE CONSOLE}


function TReverseIntComparer.Compare(const Left, Right: Integer): Integer;
begin
  if Left < Right then
    Result := 1
  else if Left > Right then
    Result := -1
  else
    Result := 0;
end;

procedure TForm2.OnDictAdd(Sender: TObject; const Item: Integer; Action: TCollectionNotification);
begin
  if Action = cnAdded then
    WriteLn('TDictionary Key has been added to the dictionary');
  if Action = cnRemoved then
    WriteLn('TDictionary Key has been removed from the dictionary');
end;

procedure TForm2.Button1Click(Sender: TObject);
var
  mylist, sortlist: TList<Integer>;
  reverseComp: TReverseIntComparer;
  myarray: TArray;
  values: array of Integer;
  i: Integer;
begin
  myarray:= TArray.Create;
  Dictionary.Add(0, 0);
  try
    Randomize;
    mylist:= Generics.Collections.TList<Integer>.Create;
    reverseComp:= TReverseIntComparer.Create;
    for i := 0 to 100 - 1 do
      mylist.Add(Random(100));
    for i := 0 to mylist.Count - 1 do
      Listbox1.Items.Add(IntToStr(mylist[i]));
    mylist.Sort;
    for i := 0 to mylist.Count - 1 do
      Listbox2.Items.Add(IntToStr(mylist[i]));
    mylist.Delete(0);
    mylist.Delete(2);
    mylist.Delete(4);
    for i := 0 to mylist.Count - 1 do
      Listbox3.Items.Add(IntToStr(mylist[i]));
    mylist.Sort(reverseComp);
    for i := 0 to mylist.Count - 1 do
      Listbox4.Items.Add(IntToStr(mylist[i]));
    sortlist:= Generics.Collections.TList<Integer>.Create(reverseComp);
    for i := 0 to 100 - 1 do
      sortlist.Add(Random(100));
    for i := 0 to mylist.Count - 1 do
      Listbox5.Items.Add(IntToStr(sortlist[i]));
    sortlist.Sort;
    for i := 0 to mylist.Count - 1 do
      Listbox6.Items.Add(IntToStr(mylist[i]));
  finally
//    reverseComp.Free;
    sortlist.Free;
    mylist.Free;
    Dictionary.Free;
    myarray.Free;
  end;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  Dictionary := TDictionary<Integer, Integer>.Create;
  Dictionary.OnKeyNotify := Form2.OnDictAdd;
end;
// EndCode
// EndExample: GenericsTList
end.
