unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Collections, Generics.Defaults;

type
  TForm3 = class(TForm)
    InMemo: TMemo;
    Button1: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}


// BeginExample: Generics_Collections_TArray
// Method: Generics.Collections.TArray.Sort
// Method: Generics.Collections.TArray.BinarySearch

// BeginCode
{
This example demonstrates the usage of TArray's static functions.
The example assumes one memo, one button and one edit box.
}
procedure TForm3.Button1Click(Sender: TObject);
var
  I, FoundIndex: Integer;
  Arr: array of String;
begin
  { Populate an array with the items in the memo }
  SetLength(Arr, InMemo.Lines.Count);

  for I := 0 to InMemo.Lines.Count - 1 do
    Arr[I] := InMemo.Lines[I];

  { Sort the array }
  TArray.Sort<String>(Arr, TStringComparer.Ordinal);

  { Binary search the required value }
  if TArray.BinarySearch<String>(Arr, Edit1.Text, FoundIndex, TStringComparer.Ordinal) then
  begin
    { Element was found. Show a message! }
    MessageDlg('Element "' + Edit1.Text + '" was found in the list!', mtInformation, [mbOK], 0);
  end else
  begin
    { Element was not found. Show a message! }
    MessageDlg('Element "' + Edit1.Text + '" was not found in the list!', mtError, [mbOK], 0);
  end;
end;
// EndCode
// EndExample: Generics_Collections_TArray

end.
