unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Collections;

type
  TForm3 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: Generics_Collections_TObjectList
// Class: Generics.Collections.TObjectList
// Property: Generics.Collections.TObjectList.OwnsObjects

// BeginCode
{
This example demonstrates the usage of the generic TObjectList class.
}
type
  { Declare a new object type }
  TNewObject = class
  private
    FName: String;

  public
    constructor Create(const AName: String);
    destructor Destroy(); override;
  end;

{ TNewObject }

constructor TNewObject.Create(const AName: String);
begin
  FName := AName;
end;

destructor TNewObject.Destroy;
begin
  { Show a message whenever an object is destroyed }
  MessageDlg('Object "' + FName + '" was destroyed!', mtInformation, [mbOK], 0);
  inherited;
end;

procedure TForm3.Button1Click(Sender: TObject);
var
  List: TObjectList<TNewObject>;
  Obj: TNewObject;
begin
  { Create a new List }
  List := TObjectList<TNewObject>.Create();

  { Set the OwnsObjects to true - the List will free them automatically }
  List.OwnsObjects := true;

  { Add some items up the List }
  List.Add(TNewObject.Create('One'));
  List.Add(TNewObject.Create('Two'));

  { Add a new item but keep the reference }
  Obj := TNewObject.Create('Three');
  List.Add(Obj);

  {
    Remove an instance of TNewObject class. Destructor
    should be called because we have set the OwnsObjects
    to true!
  }
  List.Delete(0);
  List.Extract(Obj);

  { Destroy the List completely - more messageboxes will be shown }
  List.Free;
end;
// EndCode
// EndExample: Generics_Collections_TObjectList

end.
