unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Collections;

type
  TForm3 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: Generics_Collections_TObjectQueue
// Class: Generics.Collections.TObjectQueue
// Method: Generics.Collections.TObjectQueue.Dequeue
// Property: Generics.Collections.TObjectQueue.OwnsObjects

// BeginCode
{
This example demonstrates the usage of the generic TObjectQueue class.
}
type
  { Declare a new object type }
  TNewObject = class
  private
    FName: String;

  public
    constructor Create(const AName: String);
    destructor Destroy(); override;
  end;

{ TNewObject }

constructor TNewObject.Create(const AName: String);
begin
  FName := AName;
end;

destructor TNewObject.Destroy;
begin
  { Show a message whenever an object is destroyed }
  MessageDlg('Object "' + FName + '" was destroyed!', mtInformation, [mbOK], 0);
  inherited;
end;

procedure TForm3.Button1Click(Sender: TObject);
var
  Queue: TObjectQueue<TNewObject>;
  Button: TButton;
begin
  { Create a new Queue }
  Queue := TObjectQueue<TNewObject>.Create();

  { Set the OwnsObjects to true - the Queue will free them automatically }
  Queue.OwnsObjects := true;

  { Enqueue some items up the Queue }
  Queue.Enqueue(TNewObject.Create('One'));
  Queue.Enqueue(TNewObject.Create('Two'));
  Queue.Enqueue(TNewObject.Create('Three'));

  {
    Dequeue an instance of TNewObject class. Destructor
    show be called because we have set the OwnsObjects
    to true!
  }
  Queue.Dequeue();

  { Destroy the Queue completely - more messageboxes will be shown }
  Queue.Free;
end;
// EndCode
// EndExample: Generics_Collections_TObjectQueue

end.
