unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Collections;

type
  TForm3 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: Generics_Collections_TObjectStack
// Class: Generics.Collections.TObjectStack
// Method: Generics.Collections.TObjectStack.Pop
// Property: Generics.Collections.TObjectStack.OwnsObjects

// BeginCode
{
This example demonstrates the usage of the generic TObjectStack class.
}
type
  { Declare a new object type }
  TNewObject = class
  private
    FName: String;

  public
    constructor Create(const AName: String);
    destructor Destroy(); override;
  end;

{ TNewObject }

constructor TNewObject.Create(const AName: String);
begin
  FName := AName;
end;

destructor TNewObject.Destroy;
begin
  { Show a message whenever an object is destroyed }
  MessageDlg('Object "' + FName + '" was destroyed!', mtInformation, [mbOK], 0);
  inherited;
end;

procedure TForm3.Button1Click(Sender: TObject);
var
  Stack: TObjectStack<TNewObject>;
  Button: TButton;
begin
  { Create a new stack }
  Stack := TObjectStack<TNewObject>.Create();

  { Set the OwnsObjects to true - the stack will free them automatically }
  Stack.OwnsObjects := true;

  { Push some items up the stack }
  Stack.Push(TNewObject.Create('One'));
  Stack.Push(TNewObject.Create('Two'));
  Stack.Push(TNewObject.Create('Three'));

  {
    Pop an instance of TNewObject class. Destructor
    show be called because we have set the OwnsObjects
    to true!
  }
  Stack.Pop();

  { Destroy the stack completely - more messageboxes will be shown }
  Stack.Free;
end;
// EndCode
// EndExample: Generics_Collections_TObjectStack

end.
