unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Generics.Collections;

type
  TForm3 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure QueueChanged(Sender: TObject; const Item: String; Action: TCollectionNotification);

  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: Generics_Collections_TQueue
// Class: Generics.Collections.TQueue
// Event: Generics.Collections.TQueue.OnNotify
// Method: Generics.Collections.TQueue.Enqueue
// Method: Generics.Collections.TQueue.Dequeue
// Method: Generics.Collections.TQueue.Extract
// Method: Generics.Collections.TQueue.Peek
// Method: Generics.Collections.TQueue.TrimExcess
// Method: Generics.Collections.TQueue.Clear
// Property: Generics.Collections.TQueue.Count

// BeginCode
{
This example demonstrates the usage of the generic TQueue class.
}
procedure TForm3.Button1Click(Sender: TObject);
var
  Queue: TQueue<String>;
begin
  { Create a new Queue }
  Queue := TQueue<String>.Create();

  { Register a notification call-back }
  Queue.OnNotify := QueueChanged;

  { Enqueue some items up the Queue }
  Queue.Enqueue('John');
  Queue.Enqueue('Mary');
  Queue.Enqueue('Bob');
  Queue.Enqueue('Anna');
  Queue.Enqueue('Erica');

  { Show the last enqueued element without modifying the Queue }
  MessageDlg('First enqueued element is: "' + Queue.Peek() + '".', mtInformation, [mbOK], 0);

  { Extract the top element: "Erica" }
  Queue.Extract();

  { Reduce the capacity }
  Queue.TrimExcess();

  { The remaining count of elements }
  MessageDlg('The queue contains ' + IntToStr(Queue.Count) + ' elements.', mtInformation, [mbOK], 0);

  { Show the last enqueued element by modifying the Queue }
  MessageDlg('First enqueued element is: "' + Queue.Dequeue() + '".', mtInformation, [mbOK], 0);

  { Clear the Queue }
  Queue.Clear();

  { Destroy the Queue completely }
  Queue.Free;
end;

procedure TForm3.QueueChanged(Sender: TObject; const Item: String; Action: TCollectionNotification);
begin
  { This method is called by the List everytime a change occurs }
  if Action = cnAdded then
     MessageDlg('Element added: ' + Item, mtInformation, [mbOK], 0)
  else if Action = cnRemoved then
     MessageDlg('Element removed: ' + Item, mtInformation, [mbOK], 0)
  else if Action = cnExtracted then
     MessageDlg('Element extracted: ' + Item, mtInformation, [mbOK], 0)
end;
// EndCode
// EndExample: Generics_Collections_TQueue
end.
