unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Generics.Collections, Generics.Defaults, StdCtrls;

type
  TForm3 = class(TForm)
    Button1: TButton;
    InMemo: TMemo;
    OutMemo: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: Generics_Defaults_TDelegatedEqualityComparer
// Class: Generics.Defaults.TDelegatedEqualityComparer
// Class: Generics.Defaults.IEqualityComparer
// Method: Generics.Defaults.TDelegatedEqualityComparer.Create
// Type: Generics.Defaults.TEqualityComparison
// Type: Generics.Defaults.THasher

// BeginCode
{
This example demonstrates the usage of TDelegatedEqualityComparer and
anonymous methods in order to create a custom comparer.
The example assumes two memos and a button are present on the form.
}
procedure TForm3.Button1Click(Sender: TObject);
var
  Dictionary: TDictionary<String, Cardinal>;
  Comparer: IEqualityComparer<String>;
  I: Integer;
  AString: String;
begin
  { Create a new delegated comparer. We will use anonymous methods }
  Comparer := TDelegatedEqualityComparer<String>.Create(
    { TEqualityComparison<String> }
    function(const Left, Right: String): Boolean
    begin
      { Make a case insensitive comparison }
      Result := CompareText(Left, Right) = 0;
    end,
    { THasher<String> }
    function(const Value: String): Integer
    begin
      { Generate a hash code. Simply return the length of the string
        as its hash code }
      Result := Length(Value);
    end);

  { Create a new dictionary of string/cardinal }
  Dictionary := TDictionary<String, Cardinal>.Create(Comparer);

  { Populate the dictionary with strings in the memo }
  for I := 0 to InMemo.Lines.Count - 1 do
  begin
    { Get the list from the memo }
    AString := InMemo.Lines[I];

    { If the string is already in the dictionary, increase its count
      by one. Otherwise add it with one by default.
    }
    if Dictionary.ContainsKey(AString) then
      Dictionary[AString] := Dictionary[AString] + 1
    else
      Dictionary.Add(InMemo.Lines[I], 1);
  end;

  { Copy the list with numbers to the memo }
  OutMemo.Clear;

  { Now populate the out memo with string and the number of times it was
    present in the initial memo}
  for AString in Dictionary.Keys do
    OutMemo.Lines.Add(AString + ':' + UIntToStr(Dictionary[AString]));

  { Free resources }
  Dictionary.Free();
end;
// EndCode
// EndExample: Generics_Defaults_TDelegatedEqualityComparer

end.
