unit GetAsHandle;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetAsHandle
// Method: Clipbrd.TClipboard.GetAsHandle
// Method: Clipbrd.TClipboard.Open
// Method: Clipbrd.TClipboard.Close
// Routine: SysUtils.StrPas

// BeginCode
{
The following code locks the memory for text on the Clipboard, then reads the text.
}

uses clipbrd;

procedure TForm1.Button1Click(Sender: TObject);
var
  MyHandle: THandle;
  TextPtr: PChar;
begin
  ClipBoard.Open;
try
{$IFNDEF UNICODE}
  MyHandle := Clipboard.GetAsHandle(CF_TEXT);
{$ELSE}
  MyHandle := Clipboard.GetAsHandle(CF_UNICODETEXT);
{$ENDIF}

  TextPtr := GlobalLock(MyHandle);
  ListBox1.Items.Add(StrPas(TextPtr));
  GlobalUnlock(MyHandle);
finally
  Clipboard.Close;
end;
end;
// EndCode
// EndExample: GetAsHandle
end.
