{
This example uses a button to copy the value of a field in the previous record into the corresponding field in the current record.
} 
procedure TForm1.CopyDataClick(Sender: TObject);
var
   SavePlace: TBookmark;
   PrevValue: Variant;
begin
   with MyData do
   begin
    { get a bookmark so that we can return to the same record }
    SavePlace := GetBookmark;
    try
      { move to prior record}
      FindPrior; 
      { get the value }
      PrevValue := Fields[0].Value;
      {Move back to the bookmark 
      this may not be the next record anymore 
      if something else is changing the dataset asynchronously }
      GotoBookmark(SavePlace);
      { Set the value }
      Fields[0].Value := PrevValue;
      { Free the bookmark }
    finally
      FreeBookmark(SavePlace);
    end;
  end;
end;
{
To ensure that the button is disabled when there is no previous record, the OnDataChange event of the DataSource detects when the user moves to the beginning of file (BOF property becomes true), and disables the button.
} 
procedure TForm1.MyDataDataChange(Sender: TObject; Field: TField);
begin
  if MyData.Bof then
    CopyData.Enabled := False
  else
    CopyData.Enabled := True;
end; 

