unit GetCharsetValues;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure AddCharacterSet(const S: string);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetCharsetValues
// Routine: Graphics.GetCharsetValues

// BeginCode
{
The following uses the GetCharsetValues procedure to fill a
string list with the names of all the available character
set constants. This string list can then be used to allow
the user to select a character set.  Here is the callback
that adds the character sets to the string list:
}
var
  CharSetList : TStringList;

procedure TForm1.AddCharacterSet(const S: string);
begin
  CharSetList.Add(S);
end;
{
Here is the code that creates the string list, fills it, and sorts the character set names.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  CharSetList := TStringList.Create;
  Graphics.GetCharsetValues(AddCharacterSet);
  CharSetList.Sort;
  ListBox1.Items := CharSetList;
  CharSetList.Destroy;
end;
// EndCode
// EndExample: GetCharsetValues
end.
