unit GetComponent;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

// BeginExample: GetComponent
// Method: Clipbrd.TClipboard.GetComponent
// Method: Clipbrd.TClipboard.SetComponent

// BeginCode
{
This example uses a button and a group box on a form. When
the user clicks the button, the button is copied to the
Clipboard and then retrieved from the Clipboard and placed
in the new parent of the button, the group box. The name of
the original button is changed to avoid having two components
with the same name at the same time.
} 
implementation

uses Clipbrd;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  groupButton : TButton;
begin
  { copy the button to the clipboard }
  Clipboard.SetComponent(Button1);
  { rename the button which is still on the form }
  Button1.Name := 'OriginalButton';
  { Now retrieve the button from the clipboard }
  { and add it to GroupBox1 }
  { Note that the clipboard button is named Button1, while }
  { the source button has been renamed to 'OriginalButton' }
  groupButton := TButton(Clipboard.GetComponent(Self, GroupBox1));
  groupButton.top := Button1.top + 30;
end;

initialization
  RegisterClasses([TButton]);{ registers the TButton class }
// EndCode
// EndExample: GetComponent
end.
