{
GetComponent, SetComponent example
This example uses a button and a group box on a form. When the user clicks the button, the button is copied to the Clipboard and then retrieved from the Clipboard and placed in the new parent of the button, the group box. The name of the original button is changed to avoid having two components with the same name at the same time.
} 
implementation
uses QClipbrd;
{$R *.xfmDFM}
procedure TForm1.Button1Click(Sender: TObject);
begin
  { copy the button to the clipboard }
  Clipboard.SetComponent(Button1);
  { rename the button which is still on the form }
  Button1.Name := 'OriginalButton';
  { Now retrieve the button from the clipboard }
  { and add it to GroupBox1 }
  { Note that the clipboard button is named Button1, while }
  { the source button has been renamed to 'OriginalButton' }
  Clipboard.GetComponent(Self, GroupBox1);
end;
initialization
  RegisterClasses([TButton]);{ registers the TButton class }
end. 
