{
TCanvas.Create, GetDeviceContext, Handle, Palette example
The GetFormImage allows you to easily obtain a bitmap of a form. The following method can be added to a custom TWinControl descendant to save itself as a bitmap.
} 
type
  LogPal = record
  lpal : TLogPalette; 
  dummy:Array[0..255] of TPaletteEntry; 
  end;  

procedure TMyControl.SaveAsBmp(fileName: TFileName);
var
  Source: TComponent;
  SysPal : LogPal;
  tempCanvas: TCanvas;
  sourceRect, destRect: TRect;
  image2save: TImage;
  notUsed: HWND;
begin
  tempCanvas := TCanvas.Create;
  try
    tempCanvas.Handle := GetDeviceContext(notUsed);
    image2save:=TImage.create(self);
    try
      with image2save do
      begin
        Height := Self.Height;
        Width :=  Self.Width;
        destRect := Rect(0,0,Width,Height);
        sourceRect := destRect;
        Canvas.CopyRect(destRect,tempCanvas,sourceRect);
        SysPal.lPal.palVersion:=$300;
        SysPal.lPal.palNumEntries:=256;
        GetSystemPaletteEntries(tempCanvas.Handle,0,256,SysPal.lpal.palPalEntry);
        Picture.Bitmap.Palette:= CreatePalette(Syspal.lpal);
      end;
      image2save.Picture.SaveToFile(fileName);
    finally
     image2save.Free;
    end;
  finally
    tempCanvas.Free;
  end;
end; 
