unit GetFormImage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Clipbrd;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Button1: TButton;
    Shape1: TShape;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetFormImage
// Method: Forms.TCustomForm.GetFormImage
// Property: ExtCtrls.TImage.Picture
// Method: Clipbrd.TClipboard.Assign
// Method: Graphics.TPicture.Assign

// BeginCode
{
This example uses an image, a button, and a shape component
on a form. When the user clicks the button, an image of the
form is stored in the FormImage variable and copied to the
Clipboard. The image of the form is then copied back to
the image component, producing an interesting result,
especially if the button is clicked multiple times.  Add
ExtCtrls, StdCtrls, and Clipbrd to the uses clause.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  FormImage: TBitmap;
begin
  FormImage := GetFormImage;
  try
    Clipboard.Assign(FormImage);
    Image1.Picture.Assign(Clipboard);
  finally
    FormImage.Free;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Shape1.Shape := stEllipse;
  Shape1.Brush.Color := clLime;
  Image1.Stretch := True;
end; 
// EndCode
// EndExample: GetFormImage
end.
