unit GetHitTestInfoAt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TV: TTreeView;
    ListBox1: TListBox;
    procedure TVMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetHitTestInfoAt
// Method: ComCtrls.TCustomTreeView.GetHitTestInfoAt

// BeginCode
{
The following code checks a list of htHitTest types and adds
the ones that occur when the mouse was pressed while on the
tree view.
}
procedure TForm1.TVMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  MyHitTest : THitTests;
begin
  MyHitTest := TV.GetHitTestInfoAt(X,Y);
  if htNowhere in MyHitTest then
    ListBox1.Items.Add('NoWhere');
  if htOnItem in MyHitTest then
    ListBox1.Items.Add('OnItem');
  if htOnButton in MyHitTest then
    ListBox1.Items.Add('OnButton');
  if htOnIndent in MyHitTest then
    ListBox1.Items.Add('OnIndent');
  if htOnLabel in MyHitTest then
    ListBox1.Items.Add('OnLabel');
  if htOnRight in MyHitTest then
    ListBox1.Items.Add('OnRight');
end;
// EndCode
// EndExample: GetHitTestInfoAt
end.
