unit GetNextItem;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    ListView1: TListView;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetNextItem
// Method: ComCtrls.TCustomListView.GetNextItem

// BeginCode
{
This example demonstrates how to retrieve all selected items
in a ListView component and add the Caption of the selected
ListItems to a ListBox component.
Add a button, a listview, and a listbox to the form.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  Item: TListItem;
begin
  Item := ListView1.Selected;
  while Item <> nil do
  begin
    ListBox1.Items.Add(Item.Caption);
    Item := ListView1.GetNextItem(Item, sdAll, [isSelected]);
  end;
end; 

procedure TForm1.FormCreate(Sender: TObject);
var ListItem : TListItem;
begin
  ListView1.ViewStyle := vsList;
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Apples';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Oranges';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Pears';
end;
// EndCode
// EndExample: GetNextItem
end.
