unit GetPrevChild;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Dialogs,
  Menus, Controls, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Button1: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GetPrevChild
// Property: ComCtrls.TTreeNode.Parent
// Method: ComCtrls.TTreeNode.GetNextChild
// Method: ComCtrls.TTreeNode.GetPrevChild

// BeginCode
{
The following code tests to see if the currently selected
item has a sibling; if so, HasSibling will be set to true.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  HasSibling: Boolean;
  SelNode: TTreeNode;
  ParentNode: TTreeNode;
begin
  SelNode := TreeView1.Selected;
  ParentNode := SelNode.Parent;
  HasSibling := (ParentNode.GetPrevChild(SelNode) <> nil) or
                (ParentNode.GetNextChild(SelNode) <> nil);
  if (HasSibling) then Edit1.Text := 'True'
  else Edit1.Text := 'False';
end;
// EndCode
// EndExample: GetPrevChild
end.

