unit GetStaticRect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ExtDlgs, Buttons;

// BeginExample: GetStaticRect
// Method: Dialogs.TOpenDialog.GetStaticRect

// BeginCode
{
The following example overrides the
TOpenPictureDialog.DoShow method and implements it here.
DoShow calculates the preview rectangle based on the
difference between the client area of the dialog and the
static area of the standard controls.
}
type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
  MyOpenPictureDialog = class(TOpenPictureDialog)
  private
    FPicturePanel: TPanel; // can't use the private versions in TOpenPictureDialog
    FPictureLabel: TLabel;
    FPreviewButton: TSpeedButton;
    FPaintPanel: TPanel;
    FImageCtrl: TImage;
    FSavedFilename: string;
  public
    { Public declarations }
  protected
    procedure DoShow; override;
  end;
var
  Form1: TForm1;
  OpenPictureDialog1: MyOpenPictureDialog;

implementation

{$R *.dfm}

procedure MyOpenPictureDialog.DoShow;
var
  PreviewRect, StaticRect: TRect;
begin
  FPicturePanel:= TPanel.Create(Self);
  FPictureLabel:= TLabel.Create(Self);
  FPreviewButton:= TSpeedButton.Create(Self);
  FPaintPanel:= TPanel.Create(Self);
  FImageCtrl:= TImage.Create(Self);
  // Set preview area to entire dialog
  GetClientRect(Handle, PreviewRect);
  StaticRect := GetStaticRect;
  // Move preview area to right of static area
  PreviewRect.Left := StaticRect.Left + (StaticRect.Right - StaticRect.Left);
  Inc(PreviewRect.Top, 4);
  FPicturePanel.BoundsRect := PreviewRect;
  FPreviewButton.Left := FPaintPanel.BoundsRect.Right - FPreviewButton.Width - 2;
  FImageCtrl.Picture := nil;
  FSavedFilename := '';
  FPaintPanel.Caption := '';
  FPicturePanel.ParentWindow := Handle;
//  TCommonDialog.DoShow;  // this is the one TOpenPictureDialog.DoShow calls
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
      Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenPictureDialog1:= MyOpenPictureDialog.Create(Form1);
//  OpenPictureDialog1.Parent:= Form1;
//  OpenPictureDialog1.visible := false;
end;
// EndCode
// EndExample: GetStaticRect
end.
