unit GridLineWidth;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ImgList, StdCtrls;

type
  TForm1 = class(TForm)
    DrawGrid1: TDrawGrid;
    ImageList1: TImageList;
    Button1: TButton;
    procedure DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: GridLineWidth
// Property: Grids.TCustomGrid.DefaultColWidth
// Property: Grids.TCustomGrid.GridLineWidth

// BeginCode
{
The following code uses the bitmaps in an image list
component to draw the contents of each cell in a draw grid.
This example includes a draw grid on a form. When the
application runs and the form is created, the width of the
lines on the draw grid changes if the default column width of
the grid is over 90 pixels wide.  This example requires a
populated image list, or can just display an empty grid.
Set the drawgrid DefaultColWidth and GridLineWidth statically
to values the cause the button click to do something.
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  if DrawGrid1.DefaultColWidth > 90 then
    DrawGrid1.GridLineWidth := 2
  else
    DrawGrid1.GridLineWidth := 1;
end;

procedure TForm1.DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  index: Integer;
begin
  index := ARow * DrawGrid1.ColCount + ACol;
  DrawGrid1.Canvas.Brush.Color := clBackground;
  DrawGrid1.Canvas.FillRect(Rect);
  ImageList1.Draw(DrawGrid1.Canvas,Rect.Left,Rect.Top,index, True);
  if (gdFocused in State) then
  begin
    DrawGrid1.Canvas.DrawFocusRect(Rect);
  end;
end;

procedure TForm1.DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  CanSelect:= True;
end;
// EndCode
// EndExample: GridLineWidth

end.
