unit HeaderSection;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    HeaderControl1: THeaderControl;
    procedure FormCreate(Sender: TObject);
    procedure HeaderControl1DrawSection(HeaderControl: THeaderControl;
      Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: HeaderSection
// Event: ComCtrls.THeaderControl.OnDrawSection
// Property: ComCtrls.THeaderControl.Sections
// Property: ComCtrls.TCustomHeaderControl.Canvas
// Property: ComCtrls.THeaderSection.Style
// Property: ComCtrls.THeaderSection.Text
// Method: Graphics.TCanvas.TextOut
// Property: Graphics.TFont.Color

// BeginCode
{
Add a THeaderControl to the form and call 
HeaderControl1DrawSection for the OnDrawSection event.
}
procedure TForm1.FormCreate(Sender: TObject);
var
  HeaderSection: THeaderSection;
  I: Integer;
begin
  for I := 0 to 4 do
  begin
    HeaderSection := HeaderControl1.Sections.Add;
    HeaderSection.Text := 'Text Section ' + IntToStr(I);
    HeaderSection.MinWidth := length(HeaderSection.Text) * Font.Size;
    // Owner draw every other section
    if (I mod 2 = 0) then
      HeaderSection.Style := hsOwnerDraw
    else
      HeaderSection.Style := hsText;
  end;
end;

procedure TForm1.HeaderControl1DrawSection(HeaderControl: THeaderControl;
  Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
begin
  with HeaderControl.Canvas do
  begin
    // highlight pressed sections
    if Pressed then
      Font.Color := clRed
    else
      Font.Color := clBlue;
    TextOut(Rect.Left + Font.Size, Rect.Top + 2, 'Owner Drawn text');
  end;
end;
// EndCode
// EndExample: HeaderSection
end.
