{
HeaderSection, OnDrawSection, Sections, Canvas, TextOut example
}
procedure TForm1.FormCreate(Sender: TObject);
var
  HeaderSection: THeaderSection;
  I: Integer;
begin
  for I := 0 to 4 do
  begin
    HeaderSection := HeaderControl1.Sections.Add;
    HeaderSection.Text := 'Text Section ' + IntToStr(I);
    HeaderSection.MinWidth := length(HeaderSection.Text) * Font.Size;
    // Owner draw every other section
    if (I mod 2 = 0) then
      HeaderSection.Style := hsOwnerDraw
    else
      HeaderSection.Style := hsText;
  end;
end;

procedure TForm1.HeaderControl1DrawSection(HeaderControl: THeaderControl;
  Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
begin
  with HeaderControl.Canvas do
  begin
    // highlight pressed sections
    if Pressed then
      Font.Color := clRed
    else
      Font.Color := clBlue;
    TextOut(Rect.Left + Font.Size, Rect.Top + 2, 'Owner Drawn text');
  end;
end;
 
