unit HideScrollBars;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    CheckBox1: TCheckBox;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: HideScrollBars
// Property: ComCtrls.TCustomRichEdit.HideScrollBars
// Property: StdCtrls.TCustomMemo.ScrollBars
// Property: StdCtrls.TCustomMemo.WordWrap
// Routine: System.Chr

// BeginCode
{
This example requires: TRichEdit, TRadioGroup, TCheckBox, 
TButton. Clicking the Radio Group control sets the ScrollBar
style of the RichEdit. Toggling the Check Box turns 
HideScrollBars on and off.  Clicking the button loads the 
Rich Edit with a large amount of contiguous text.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  RichEdit1.Lines.Clear;
  for I := 0 to 500 do
  begin
    RichEdit1.Text :=
      RichEdit1.Text + 'test line ' + IntToStr(I) + ' ';
    if (i mod 4 = 0) then
      RichEdit1.Text := RichEdit1.Text + Chr(13);
  end;
  // move text cursor to top of editend;
  RichEdit1.SelStart := 0; 
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  RichEdit1.HideScrollbars := CheckBox1.Checked;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
const
  ScrollBarA: array[0..3] of TScrollStyle = (
    ssBoth,
    ssHorizontal,
    ssNone,
    ssVertical);
begin
  RichEdit1.ScrollBars := 
    ScrollBarA[RadioGroup1.ItemIndex];
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with RadioGroup1, Items do
  begin
    Caption := 'Scroll Bars';
    Clear;
    Add('ssBoth');
    Add('ssHorizontal');
    Add('ssNone');
    Add('ssVertical');
  end;
  with CheckBox1 do
  begin
    Caption := 'HideScrollBars';
    Checked := True;
  end;
  Button1.Caption := 'Loaded';
  RichEdit1.Text := 'Just a little text.';
  RichEdit1.WordWrap := False;
end;
// EndCode
// EndExample: HideScrollBars
end.

