
(*
 Delphi Object and Component Reference
#{bmc bm10.BMP} HideScrollBars, ScrollBars example
This example requires: TRichEdit, TRadioGroup, TCheckBox, TButton. Clicking the Radio Group control sets the ScrollBar style of the RichEdit. Toggling the Check Box turns HideScrollBars on and off.  Clicking the button loads the Rich Edit with a large amount of contiguous text.
*) 
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  RichEdit1.Lines.Clear;
  for I := 0 to 500 do
    RichEdit1.Text := RichEdit1.Text + 'test line ' + IntToStr(I);
  RichEdit1.SelStart := 0; // move text cursor to top of edit
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  RichEdit1.HideScrollbars := CheckBox1.Checked;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
const
  ScrollBarA: array[0..3] of TScrollStyle = (
    ssBoth,
    ssHorizontal,
    ssNone,
    ssVertical);
begin
  RichEdit1.ScrollBars := ScrollBarA[RadioGroup1.ItemIndex];
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with RadioGroup1, Items do
  begin
    Caption := 'Scroll Bars';
    Clear;
    Add('ssBoth');
    Add('ssHorizontal');
    Add('ssNone');
    Add('ssVertical');
  end;
  with CheckBox1 do
  begin
    Caption := 'HideScrollBars';
    Checked := True;
  end;
  Button1.Caption := 'Loaded';
end;
 
