unit HotKey;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    HotKey1: THotKey;
    Top1: TMenuItem;
    Item11: TMenuItem;
    Item21: TMenuItem;
    Item31: TMenuItem;
    SecondFolder1: TMenuItem;
    File1: TMenuItem;
    New1: TMenuItem;
    Item41: TMenuItem;
    procedure File1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: HotKey
// Property: ComCtrls.TCustomHotKey.HotKey
// Property: ComCtrls.TCustomHotKey.InvalidKeys
// Property: ComCtrls.TCustomHotKey.Modifiers

// BeginCode
{
To use this example, create a form with a main menu 
component and a HotKey component.  At design time, use the 
Menu designer to add menu items, including a "File" menu 
with subitems that includes a "New" menu item.  Add the 
following code to the OnCreate method of the form and the 
OnClick event of the File menu item.
}
procedure TForm1.File1Click(Sender: TObject);
begin
  // Assign hotkey to the menu's File "New" item. 
  New1.ShortCut := HotKey1.HotKey;  
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Default to "Ctrl + A"
  HotKey1.Modifiers := [hkCtrl];
  // Don't allow shift or alt
  HotKey1.InvalidKeys := [hcShift, hcAlt];
end;
// EndCode
// EndExample: HotKey
end.
