unit IndexName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    Button2: TButton;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    Button5: TButton;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Button3: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS2.LoadFromFile(GetCurrentDir + '\CDS2.XML');
{$ELSE}
  CDS2.LoadFromFile(gsAppPath + 'CDS2.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS2.SaveToFile(GetCurrentDir + '\CDS2.XML', dfXML);
{$ELSE}
  CDS2.SaveToFile(gsAppPath + 'CDS2.XML', dfXML);
{$ENDIF}
end;

// BeginExample: IndexName
// Property: DBClient.TCustomClientDataSet.IndexDefs
// Property: DBClient.TCustomClientDataSet.IndexName
// Property: DB.TIndexDefs.Update
// Property: Classes.TCollection.Count
// Property: DB.TIndexDefs.Items
// Property: DB.TIndexDef.Fields
// Property: DB.TNamedItem.Name

// BeginCode
{
This example uses the IndexName property to sort the records
in a client dataset on the Field2 field.
}
procedure TForm1.Button3Click(Sender: TObject);
var
  I : Integer;
begin
  // If Active is True, Update will remove Fields added in FormCreate
  // and add the DEFAULT_ORDER and CHANGEINDEX Fields
  CDS2.Active := False;
  { Get the current available indices }
  CDS2.IndexDefs.Update;
  { Find a field named 'Field2' }
  for I := 0 to CDS2.IndexDefs.Count - 1 do
    if CDS2.IndexDefs.Items[I].Fields = 'Field2' then
    begin
      { set that index as the current index for the dataset}
      CDS2.IndexName := CDS2.IndexDefs.Items[I].Name;
    end;
  CDS2.Active := True;
end;
// EndCode
// EndExample: IndexName

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS2.Close;
end;

{
The following code creates and activates a client dataset in
the forms OnCreate event handler.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  with CDS2 do
  begin
    with FieldDefs.AddFieldDef do
    begin
      DataType := ftInteger;
      Name := 'Field1';
    end;
    with FieldDefs.AddFieldDef do
    begin
      DataType := ftString;
      Size := 10;
      Name := 'Field2';
    end;
    with IndexDefs.AddIndexDef do
    begin
      Fields := 'Field2';
      Name := 'IntIndex';
    end;
    with IndexDefs.AddIndexDef do
    begin
      Fields := 'Field1';
      Name := 'OtherIndex';
    end;
    CreateDataSet;
  end;
end; 
end.
