unit IndexOfName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: IndexOfName
// Method: Classes.TStrings.IndexOfName
// Property: Classes.TStrings.Count
// Property: Classes.TStrings.Names
// Property: Classes.TStrings.Strings
// Routine: System.Pos

// BeginCode
{
The following example updates the strings in a list box
given the strings contained in another list box. If a string
in the source list box has the form Name=Value and the
destination list box contains a string with the same Name
part, the Value part in the destination list box will be
replaced by the sources value.  TListBox objects that are
not name-value pairs are not assigned a Name and IndexOfName
will return -1.
}
procedure MergeStrings(Dest, Source: TStrings);
var
  I, DI: Integer;
  begin
  for I := 0 to Source.Count - 1 do
  begin
    if Pos ('=', Source[I]) > 1 then
    begin
      DI := Dest.IndexOfName(Source.Names[I]);
      if DI > -1 then Dest[DI] := Source[I];
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MergeStrings(ListBox1.Items, ListBox2.Items);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ListBox1.Items.Add('Plants = 10');
  ListBox1.Items.Add('Animals = 20');
  ListBox1.Items.Add('Minerals = 15');
  ListBox2.Items.Add('Animals = 4');
  ListBox2.Items.Add('Plants = 3');
  ListBox2.Items.Add('Minerals = 78');
end;
// EndCode
// EndExample: IndexOfName
end.
