unit IniFiles_unit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IniFiles, Registry, StdCtrls, ExtCtrls;

type
  TForm2 = class(TForm)
    btLoad: TButton;
    btStore: TButton;
    RadioGroup1: TRadioGroup;
    procedure btLoadClick(Sender: TObject);
    procedure btStoreClick(Sender: TObject);
  private
    { Private declarations }
    function OpenIniFileInstance() : TCustomIniFile;
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: IniFilesTMemIniFile
// Class: Registry.TRegistryIniFile
// Class: IniFiles.TIniFile
// Class: IniFiles.TMemIniFile
// Class: IniFiles.TCustomIniFile
// Method: IniFiles.TCustomIniFile.ReadInteger
// Method: IniFiles.TCustomIniFile.ReadString
// Method: IniFiles.TCustomIniFile.ReadBool
// Method: IniFiles.TCustomIniFile.WriteInteger
// Method: IniFiles.TCustomIniFile.WriteString
// Method: IniFiles.TCustomIniFile.WriteBool
// Method: IniFiles.TIniFile.ReadString
// Method: IniFiles.TIniFile.WriteString
// Method: IniFiles.TMemIniFile.ReadString
// Method: IniFiles.TMemIniFile.WriteString
// Method: Registry.TRegistryIniFile.ReadInteger
// Method: Registry.TRegistryIniFile.ReadString
// Method: Registry.TRegistryIniFile.WriteInteger
// Method: Registry.TRegistryIniFile.WriteString

// BeginCode
{
This example demonstrates the use of Ini files in order to store
and load form configurations between sessions. This example requires
a RadioGroup and two buttons.
}
procedure TForm2.btLoadClick(Sender: TObject);
var
  SettingsFile : TCustomIniFile;
begin
  { Open an instance }
  SettingsFile := OpenIniFileInstance();

  try
    {
    Read all saved values from the last session. The section name
    is the name of the form. Also use form's properties as defaults
    }
    Top     := SettingsFile.ReadInteger(Name, 'Top', Top );
    Left    := SettingsFile.ReadInteger(Name, 'Left', Left );
    Width   := SettingsFile.ReadInteger(Name, 'Width', Width );
    Height  := SettingsFile.ReadInteger(Name, 'Height', Height );
    Caption := SettingsFile.ReadString (Name, 'Caption', Caption);

    { Load last window state }
    case SettingsFile.ReadBool(Name, 'InitMax', WindowState = wsMaximized) of
      true : WindowState := wsMaximized;
      false: WindowState := wsNormal;
    end;

  finally
    SettingsFile.Free;
  end;
end;

procedure TForm2.btStoreClick(Sender: TObject);
var
  SettingsFile: TCustomIniFile;
begin
  { Open an instance }
  SettingsFile := OpenIniFileInstance();

  {
  Store current form properties to be used in later sessions.
  }
  try
    SettingsFile.WriteInteger (Name, 'Top', Top);
    SettingsFile.WriteInteger (Name, 'Left', Left);
    SettingsFile.WriteInteger (Name, 'Width', Width);
    SettingsFile.WriteInteger (Name, 'Height', Height);
    SettingsFile.WriteString  (Name, 'Caption', Caption);
    SettingsFile.WriteBool    (Name, 'InitMax', WindowState = wsMaximized );
    SettingsFile.WriteDateTime(Name, 'LastRun', Now);
  finally
    SettingsFile.Free;
  end;

end;

function TForm2.OpenIniFileInstance: TCustomIniFile;
begin
  {
  Open/create a new INI file that has the same name as our executable
  only with the INI extension.
  }

  case RadioGroup1.ItemIndex of
    0:
      begin
        { Registry mode selected: in HKEY_CURRENT_USER\Software\... }
        Result := TRegistryIniFile.Create('Software\' + Application.Title);
      end;
    1:
      begin
        { Ini file mode selected }
        Result := TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI'));
      end;
    2:
      begin
        { Memory based Ini file mode selected }
        Result := TMemIniFile.Create(ChangeFileExt(Application.ExeName, '.INI'));
      end;
  end;
end;
// EndCode
// EndExample: IniFilesTMemIniFile

end.
