unit InputQuery;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: InputQuery
// Routine: Dialogs.InputQuery

// BeginCode
{
This example uses a button and a label on the form. When the
user clicks the button, the input box displays. If the user
chooses OK, the string that appears in the edit box of the
dialog box displays as the caption of the label on the form.
If the user chooses Cancel, the dialog box closes and the
caption of the label remains unchanged.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  NewString: string;
  ClickedOK: Boolean;
begin
  NewString := 'Default String';
  ClickedOK := Dialogs.InputQuery('Input Box', 'Prompt', NewString);
  if ClickedOK then            { NewString contains new input string }
    Label1.Caption := NewString;
end;
// EndCode
// EndExample: InputQuery
end.
