{
InsertObject, Name, ItemAtPos example
For the following example, add a button, a status bar, and a
list box. Set the SimplePanel property of the status bar to 
true, using the object inspector. The following code fills a
list box with the names of all components on the form when 
the user clicks the button. References to the components 
themselves are inserted along with the names. The components
are all inserted at the front of the list, so that the last
component added to the form is the first component in the 
list.  When the user right-clicks the name of an object in 
the list, the components coordinates are displayed on the 
status bar. Note that because we are using the right-click,
the item need not be selected.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to Form1.ComponentCount-1 do
    ListBox1.Items.InsertObject(0, Form1.Components[I].Name, 
                                Form1.Components[I] as TObject);
end;

procedure TForm1.ListBox1MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X,Y: integer);
var
  APoint: TPoint;
  Index: integer;
  TheObject: TControl;
begin
  if Button = mbRight then
  begin
  APoint.X := X;
  APoint.Y := Y;
  Index := ListBox1.ItemAtPos(APoint, True);
  if (ListBox1.Items.Objects[Index] is TControl) then 
  begin
    TheObject := (ListBox1.Items.Objects[Index] as TControl);
    StatusBar1.SimpleText := TheObject.Name + ' is at (' + 
                           IntToStr(TheObject.Left) + ', ' +
                           IntToStr(TheObject.Top) + ') ';
  end
  else
    Beep;
  end;
end; 
