unit InsertRecord;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Customers: TTable;
  procedure CreateMyTable;
implementation

{$R *.dfm}

// BeginExample: InsertRecord
// Method: DB.TDataSet.InsertRecord

// BeginCode
{
This statement inserts a record to the MyCustInfo data. Note
that Nulls are entered for some of the values, but are not
required for missing values at the end of the array argument,
i.e. after the Field3 field.  InsertRecord behaves differently
depending on the indexing of the table.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  Customers.InsertRecord([Edit1.Text, Edit2.Text, Null, Edit3.Text]);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'MyCustInfo';
    ReadOnly:= False;

//    Don't overwrite an existing table
    if (not Customers.Exists) then CreateMyTable
    else
    begin
      if (Customers.Exists AND
        (MessageDlg('MyCustInfo table already exists.  Do you want to rebuild it?', mtConfirmation, [mbYes, mbNo], 0) = mrYes)) then
      begin
        Customers.Close;
        Customers.DeleteTable;
        CreateMyTable;
      end;
    end;
  end;
  DS2.DataSet:= Customers;
  DBGrid2.DataSource.DataSet:= Customers;
  Customers.Active:= True;
end;

procedure CreateMyTable();
var
  i: Integer;
begin
//      The Table component must not be active
//      First, describe the type of table and give
//      it a name
//      Next, describe the fields in the table
  with Customers do
  begin
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
        with AddFieldDef do
        begin
          Name := 'Field3';
          DataType := ftString;
          Size := 30;
        end;
        with AddFieldDef do
        begin
          Name := 'Field4';
          DataType := ftString;
          Size := 30;
        end;
      end;

//    Take out this part to remove indexing
//    Next, describe any indexes
      with IndexDefs do
      begin
        Clear;
//        The 1st index has no name because it is
//        a Paradox primary key
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;

//      Call the CreateTable method to create the table
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 20 do
        Customers.AppendRecord([i*111, i*222, i*333, i*444]);
    end;
end;

// EndCode
// EndExample: InsertRecord
end.
