unit LineTo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: LineTo
// Method: Graphics.TCanvas.MoveTo
// Method: Graphics.TCanvas.LineTo

// BeginCode
{
The following code draws a line from the upper left corner 
of a form to the mouse position when the mouse is moved, 
creating a "rubber band" effect.
} 
procedure TForm1.FormMouseMove(
  Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  { first call FillRect to paint the surface of the form.
  this removes any previously drawn lines (and anything else!) }
  Canvas.FillRect(ClientRect);
  Canvas.MoveTo(0, 0);
  Canvas.LineTo(X, Y);
end;
// EndCode
// EndExample: LineTo
end.
