unit LoadFromClipboard;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Clipbrd, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: LoadFromClipBoard
// Method: Graphics.TBitmap.LoadFromClipboardFormat
// Method: Graphics.TBitmap.SaveToClipboardFormat
// Method: Graphics.TPicture.RegisterClipboardFormat
// Routine: Clipbrd.Clipboard
// Method: Clipbrd.TClipboard.GetAsHandle
// Method: Clipbrd.TClipboard.SetAsHandle
// Method: Clipbrd.TClipboard.Clear

// BeginCode
{
The following code draws a bitmap image from the Clipboard 
when a button is pressed.  The SaveToClipboard button must 
be selected before the LoadFromClipboard button in order to
place the icon on the clipboard.
}

procedure TForm1.Button1Click(Sender: TObject);
var
  Bitmap : TBitmap;
  s : string;
  Icon: TIcon;
begin
 Bitmap := TBitMap.Create;
 try
   Image1.Picture.RegisterClipboardFormat(cf_BitMap,TIcon);
   Bitmap.LoadFromClipBoardFormat(
     cf_BitMap,ClipBoard.GetAsHandle(cf_Bitmap),0);
   Canvas.draw(0,0,Bitmap);
 finally
   Bitmap.free;
   Clipboard.Clear;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  MyFormat : Word;
  Bitmap : TBitMap;
  AData : THandle;
  APalette : HPALETTE;
begin
  Bitmap := TBitmap.Create;
  try
    Bitmap.LoadFromFile('c:\Program Files\Common Files\CodeGear Shared\Images\Splash\256color\factory.bmp');
    Bitmap.SaveToClipBoardFormat(
      MyFormat,
      AData,
      APalette);
    ClipBoard.SetAsHandle(MyFormat,AData);
  finally
    Bitmap.Free;
  end;
end;
// EndCode
// EndExample: LoadFromClipBoard
end.
