unit LoadFromFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: LoadFromFile
// Method: Graphics.TBitmap.Assign
// Method: Graphics.TBitmap.Dormant
// Method: Graphics.TBitmap.FreeImage
// Property: Graphics.TBitmap.Monochrome
// Method: Graphics.TBitmap.ReleaseHandle
// Property: Graphics.TGraphic.LoadFromFile

// BeginCode
{
This example uses a button on a form and creates two bitmaps
dynamically.  One bitmap is monchrome, which means all
non-white colors become black.  The bitmap file path is
relative to the Debug directory.
}
procedure TForm1.Button1Click(Sender: TObject);
var
 BitMap1,BitMap2 : TBitMap;
 MyFormat : Word;
begin
   BitMap2 := TBitMap.Create;
   BitMap1 := TBitMap.Create;
try
   BitMap1.LoadFromFile('factory.bmp');
   BitMap2.Assign(BitMap1);     // Copy BitMap1 into BitMap2
   BitMap2.Dormant;             // Free up GDI resources
   BitMap2.FreeImage;           // Free up Memory.
   Canvas.Draw(20,20,BitMap2);  // Note that previous calls don't lose the image
   BitMap2.Monochrome := true;
   Canvas.Draw(80,80,BitMap2);
   BitMap2.ReleaseHandle;       // This will actually lose the bitmap;
 finally
   BitMap1.Free;
   BitMap2.Free;
 end;
end;
// EndCode
// EndExample: LoadFromFile
end.
