{
SaveToStream, LoadFromStream example
This example requires TListBox, TMemo, TRichEdit, and TButton controls placed on the form. The list box should contain one or more items.
When the form becomes visible, click on the button and the contents of the list box will be transferred to the memo (cross-platform) or rich edit (Windows) control.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  TempStream : TMemoryStream;
begin
  TempStream := TMemoryStream.Create;

  ListBox1.Items.SaveToStream(TempStream);  // write list box contents to the 
                                            // stream
  TempStream.Position := 0;      // reset to the beginning of the stream
  RichEdit1.Lines.LoadFromStream( TempStream); // load stream contents into rich 
                                               // edit control

  TempStream.Free;
end;
On Cross-platform:
procedure TForm1.Button1Click(Sender: TObject);
var
  TempStream : TMemoryStream;
begin
  TempStream := TMemoryStream.Create;

  ListBox1.Items.SaveToStream(TempStream);  // write list box contents to the 
                                            // stream
  TempStream.Position := 0;      // reset to the beginning of the stream
  Memo1.Lines.LoadFromStream( TempStream);  // load stream contents into memo
                                            // control

  TempStream.Free;
end;
 
