unit MDIChildren;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    MyArrangeIcons: TMenuItem;
    MyCascade: TMenuItem;
    CloseChildren: TMenuItem;
    procedure MyArrangeIconsClick(Sender: TObject);
    procedure MyCascadeClick(Sender: TObject);
    procedure CloseChildrenClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: MDIChildren
// Property: Forms.TCustomForm.MDIChildren
// Property: Forms.TCustomForm.MDIChildCount
// Method: Forms.TCustomForm.Close

// BeginCode
{
This example uses several forms. The first form has its
FormStyle property set to MDIForm. The others have their
FormStyle properties set to MDIChild and their Visible
properties set to true. Add a main menu component and name
one of the menu items CloseChildren. This is code for the
CloseChildrenClick handler.  When the user chooses the
CloseChildren command, all the MDI children of Form1 are
closed.
} 
procedure TForm1.CloseChildrenClick(Sender: TObject);
var
  I: Integer;
begin
  with Form1 do
    for I := MDIChildCount-1 downto 0 do
      MDIChildren[I].Close;
end;

procedure TForm1.MyArrangeIconsClick(Sender: TObject);
begin
  Form1.ArrangeIcons;
end;

procedure TForm1.MyCascadeClick(Sender: TObject);
begin
  Form1.Cascade;
end;
// EndCode
// EndExample: MDIChildren
end.
